init 1 python hide:

######################################################
    translate = renpy.translation.StringTranslator.translate
    
    import re

    __renpy__dict__ = _dict 
    __renpy__list__ = _list 

######################################################
    def sim_hum_ipatch(self, t):
        t = translate(self, t)

        t = t.replace("Susan is married to Phil, her husband of 15 years","Susan is married to Phil, her husband of 17 years")
        t = t.replace("I went to University, where I met my husband, we got a house, adopted a couple of kids and thought that I was happy.","I went to University, where I met my husband, we got a house, a couple of kids and thought that I was happy.")
        t = t.replace("She has practically danced from the first day we adopted her...","She's loved dancing since she was a little girl...")

        t = t.replace("[libby_rel_to_susan]","Daughter")
        t = t.replace("[libby_rel_to_phil]","Daughter")

        t = t.replace("[adam_rel_to_susan]","Son")
        t = t.replace("[adam_rel_to_phil]","Son")

        t = t.replace("[susan_rel_to_libby]","Mother")
        t = t.replace("[susan_rel_to_adam]","Mother")

        t = t.replace("[phil_rel_to_libby]","Father")
        t = t.replace("[phil_rel_to_adam]","Father")


        t = t.replace("[ed_type]","School")
        t = t.replace("lecturer","Teacher")
        t = t.replace("Lecturer","Teacher")

        t = t.replace("Ok so I've been married for 15 years to the most devoted husband...","Ok so I've been married for 17 years to the most devoted husband...")
        t = t.replace("brief period than she had in the 15 years of marriage to Phil","brief period than she had in the 17 years of marriage to Phil")


        ##################
        t = re.sub(r'(?<!^)(?<![.!?]\s)(?<!: \')\bDaughter\b', 'daughter', t)
        t = re.sub(r'(?<!^)(?<![.!?]\s)(?<!: \')\bSon\b', 'son', t)
        t = re.sub(r'(?<!^)(?<![.!?]\s)(?<!: \')\bMother\b', 'mother', t)

        t = re.sub(r'(?<!^)(?<![.!?]\s)(?<!: \')\bFather\b', 'father', t)
        t = re.sub(r'(?<!^)(?<![.!?]\s)(?<!: \')\bSchool\b', 'school', t)
        t = re.sub(r'(?<!^)(?<![.!?]\s)(?<!: \')\bTeacher\b', 'teacher', t)

##################
        return t
        
    renpy.translation.StringTranslator.translate = sim_hum_ipatch
    del sim_hum_ipatch


    sim_hum_label = { "start": "start_i"}

    def label_callback(label, _):
        label = sim_hum_label.get(label)

        if label:
            renpy.jump(label)

    if config.label_callback:

        callbacks = [label_callback, config.label_callback]

        def label_callback(label, abnormal):
            for cb in callbacks:
                cb(label, abnormal)

    config.label_callback = label_callback
    del label_callback
    
label start_i:

    scene ip19 with dissolve

    "Before you start, set the ages of Susan and Phil's kids."

    scene tuw120 with dissolve

    $ Libby_Age = renpy.input("How old is Libby? Default: 19")
    $ Libby_Age = Libby_Age.strip()
    if Libby_Age == "":
        $ Libby_Age = "19"

    scene tuw117 with dissolve

    $ Adam_Age = renpy.input("How old is Adam? Default: 19")
    $ Adam_Age = Adam_Age.strip()
    if Adam_Age == "":
        $ Adam_Age = "19"
    $ Adam_Age = int(Adam_Age)


    $ Mike_Age = Adam_Age
    $ Sally_Age = Adam_Age - 1

    $ adamlove = 3.5
    $ libbylove = 4.5
    $ corruptionpoints = 0
    $ hotwifepoints = 0
    $ lesbianpoints = 0
    $ exhibitionistpoints = 0.5

    stop music fadeout 1.0

    scene black with fade
    jump intro
